/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.validacion.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    public static final int[] DEFAULT_STRORAGE_TREE_DISTRIBUTION = new int[]{2, 2, 2, 4};
    public static final int BUFFER_SIZE = 65536;
    protected static String s_strTempDirectory;

    public static void moveFile(File flCurrent, File flDestination) throws IOException {
        if (flCurrent.exists()) {
            File flFolder;
            if (flDestination.exists()) {
                FileUtils.renameToTemporaryName(flDestination, "old");
            }
            if (!((flFolder = flDestination.getParentFile()) == null || flFolder.exists() || flFolder.mkdirs() || flFolder.exists())) {
                throw new IOException("Cannot create directory " + flFolder);
            }
            if (!flCurrent.renameTo(flDestination)) {
                FileUtils.copyFile(flCurrent, flDestination);
                if (!flCurrent.delete()) {
                    flDestination.delete();
                    throw new IOException("Cannot delete already copied file " + flCurrent);
                }
            }
        }
    }

    public static void copyFile(File flCurrent, File flDestination) throws IOException {
        File flFolder = flDestination.getParentFile();
        if (!(flFolder == null || flFolder.exists() || flFolder.mkdirs() || flFolder.exists())) {
            throw new IOException("Cannot create directory " + flFolder);
        }
        FileInputStream finInput = null;
        try {
            finInput = new FileInputStream(flCurrent);
        }
        catch (IOException ioExec) {
            if (finInput != null) {
                try {
                    finInput.close();
                }
                catch (Throwable throwable) {}
            }
            throw ioExec;
        }
        FileUtils.copyStreamToFile(finInput, flDestination);
    }

    public static void renameToTemporaryName(File flFileToRename, String strPrefix) throws IOException {
        File flTemp;
        assert (strPrefix != null) : "Prefix cannot be null.";
        StringBuffer sbBuffer = new StringBuffer();
        int iIndex = 0;
        String strParent = flFileToRename.getParent();
        do {
            ++iIndex;
            sbBuffer.delete(0, sbBuffer.length());
            if (strParent != null) {
                sbBuffer.append(strParent);
                sbBuffer.append(File.separatorChar);
            }
            sbBuffer.append(strPrefix);
            sbBuffer.append("_");
            sbBuffer.append(iIndex);
            sbBuffer.append("_");
            sbBuffer.append(flFileToRename.getName());
        } while ((flTemp = new File(sbBuffer.toString())).exists());
        if (!flFileToRename.renameTo(flTemp)) {
            throw new IOException("Cannot rename " + flFileToRename.getAbsolutePath() + " to " + flTemp.getAbsolutePath());
        }
    }

    public static boolean deleteDirectoryContent(String strDir) {
        return strDir != null && strDir.length() > 0 ? FileUtils.deleteDirectoryContent(new File(strDir)) : false;
    }

    public static boolean deleteDirectoryContent(File fDir) {
        File[] files;
        boolean bRetval = false;
        if (fDir != null && fDir.isDirectory() && (files = fDir.listFiles()) != null) {
            bRetval = true;
            int index = 0;
            while (index < files.length) {
                boolean dirDeleted;
                bRetval = files[index].isDirectory() ? ((dirDeleted = FileUtils.deleteDirectoryContent(files[index])) ? bRetval && files[index].delete() : false) : bRetval && files[index].delete();
                ++index;
            }
        }
        return bRetval;
    }

    public static boolean deleteDir(String strDir) {
        return strDir != null && strDir.length() > 0 ? FileUtils.deleteDir(new File(strDir)) : false;
    }

    public static boolean deleteDir(File fDir) {
        boolean bRetval = false;
        if (fDir != null && fDir.exists() && (bRetval = FileUtils.deleteDirectoryContent(fDir))) {
            bRetval = bRetval && fDir.delete();
        }
        return bRetval;
    }

    public boolean isFileBinaryEqual(File first, File second) throws IOException {
        boolean retval;
        block14: {
            retval = false;
            if (first.exists() && second.exists() && first.isFile() && second.isFile()) {
                if (first.getCanonicalPath().equals(second.getCanonicalPath())) {
                    retval = true;
                } else {
                    FileInputStream firstInput = null;
                    FileInputStream secondInput = null;
                    BufferedInputStream bufFirstInput = null;
                    BufferedInputStream bufSecondInput = null;
                    try {
                        int secondByte;
                        int firstByte;
                        firstInput = new FileInputStream(first);
                        secondInput = new FileInputStream(second);
                        bufFirstInput = new BufferedInputStream(firstInput, 65536);
                        bufSecondInput = new BufferedInputStream(secondInput, 65536);
                        do {
                            if ((firstByte = bufFirstInput.read()) == (secondByte = bufSecondInput.read())) continue;
                            break block14;
                        } while (firstByte >= 0 || secondByte >= 0);
                        retval = true;
                    }
                    finally {
                        try {
                            if (bufFirstInput != null) {
                                bufFirstInput.close();
                            }
                        }
                        finally {
                            if (bufSecondInput != null) {
                                bufSecondInput.close();
                            }
                        }
                    }
                }
            }
        }
        return retval;
    }

    public static String getTemporaryDirectory() {
        return s_strTempDirectory;
    }

    public static void copyStreamToFile(InputStream input, File output) throws IOException {
        FileOutputStream foutOutput = null;
        try {
            foutOutput = new FileOutputStream(output);
        }
        catch (IOException ioExec) {
            if (foutOutput != null) {
                try {
                    foutOutput.close();
                }
                catch (IOException iOException) {}
            }
            throw ioExec;
        }
        FileUtils.copyStreamToStream(input, foutOutput);
    }

    public static void copyStreamToStream(InputStream input, OutputStream output) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int ch;
            is = input instanceof BufferedInputStream ? input : new BufferedInputStream(input);
            os = output instanceof BufferedOutputStream ? output : new BufferedOutputStream(output);
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            os.flush();
        }
        finally {
            IOException exec1 = null;
            IOException exec2 = null;
            try {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException exec) {
                        exec1 = exec;
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException exec) {
                        exec2 = exec;
                    }
                }
            }
            if (exec1 != null && exec2 != null) {
                throw exec1;
            }
            if (exec1 != null) {
                throw exec1;
            }
            if (exec2 != null) {
                throw exec2;
            }
        }
    }
}

